@echo off
REM ************ Properties *************
setlocal enabledelayedexpansion
SET LIST_FILE_NAME=machines.txt
SET ADAM_EXECUTE=Adam.exe

REM ************ Validations ************
if not exist %ADAM_EXECUTE% (
echo - ERROR: Unable to find the Adam Remote Automation tool: '%ADAM_EXECUTE%'.
goto FINISH
)

if not exist %LIST_FILE_NAME% (
echo - ERROR: Unable to find the machines list file: '%LIST_FILE_NAME%'.
goto FINISH
)

REM ********* Parsing the file **********
for /f "tokens=1-3" %%A in ('type %LIST_FILE_NAME%') do (
if "%%A" NEQ "" set adamRemoteMachine=-DremoteMachine=%%A
if "%%B" NEQ "" set adamUserName=-DuserName=%%B
if "%%C" NEQ "" set adamUserPassword=-DuserPassword=%%C

REM ********* Execute Adam Tool *********
echo.
echo.
SET CMD=%ADAM_EXECUTE% !adamRemoteMachine! !adamUserName! !adamUserPassword! %*
echo - Executing !CMD!
echo.
!CMD!
)

:FINISH
